#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Importujemy niezbędne moduły
from gimpfu import *
def add_colored_border(image, drawable, border_width, border_color):
  pdb.gimp_context_push()
  # Zakazujemy zapisu informacji dla umżliwienia cofnięć,
  # aby wszystkie operacje wykonane wtyczką można było anulować jednym klikiem
  # klikając Ctrl + Z lub wybierając w menu "Edycja" punkt "Cofnij"
  pdb.gimp_image_undo_group_start(image)
# Powiększamy rozmiar płótna I przesuwamy na wymaganą odległość
  pdb.gimp_image_resize(image,
                        pdb.gimp_image_width(image)  + border_width,
                        pdb.gimp_image_height(image)  + border_width,
                        border_width / 2,
                        border_width / 2)
  # Zapamiętujemy kolor Tła.
  # Jest to również zasada dobrego tonu:
  # pozostawiać po sobie stan początkowy
  old_background = pdb.gimp_context_get_background()
  # Zmieniamy kolor Tła
  pdb.gimp_context_set_background(border_color)
  # Spłaszczamy obraz
  pdb.gimp_image_flatten(image)
  # Przywracamy do stanu początkowego kolor Tła
  pdb.gimp_context_set_background(old_background)
  # Aktualizujemy obraz na wyświetlaczu
  pdb.gimp_displays_flush()
# Zezwalamy na zapis informacji dla zmiany działania
  pdb.gimp_image_undo_group_end(image)
  pdb.gimp_context_pop()
# Rejestrujemy funkcję w PDB 
register(
          "add_colored_border", # Jeśli tak zapiszemy nazwę procedury rejestrującej wtyczkę, GIMP zmieni 
		  #podkreślenia na myślniki i doda prefiks "python-fu" (lepiej prefiksu samemu nie dodawać). 
          "Dodanie kolorowej ramki do obrazu ", # Krótki opis działań wykonywanych przez wtyczkę, 
		  # zobaczymy go po umieszczeniu wskaźnika myszki na nazwie punktu w menu. 
          "Rysuje dookoła obrazu ramkę podanego koloru i podanej szerokości ", # Informacja dokumentacyjna 
		  #o wtyczce, która pojawi się w Przeglądarce procedur, należy wyjaśnić w bardziej szczegółowy 
		  #sposób realizowane funkcje przez wtyczkę 
          "Alfa Beta", # Autor wtyczki 
          "Alfa Beta (alfa.beta@gmail.com)", # Informacja o właścicielu prawach autorskich (Copyright) 
		  #i np. GPL (General Public License) oraz ewent. adres email 
          "30.05.2015", # Data utworzenia wtyczki 
          "_Dodaj ramkę...", # Etykieta, nazwa punktu w menu, za pomocą której, wtyczka będzie uruchamiana. 
		  # W nazwie Etykiety otwierającej okno dialogowe, używamy wielokropka ... 
		  # Zastosowanie znaku podkreślenia "_" przed pierwszym znakiem powinno spowodować, że możemy używać 
		  # skrótu klawiaturowego, wygoda jeżeli w Katalogu/podkatalogu znajduje sie więcej wtyczek. 
		  # Klikamy na katalog i potem skrót.
          "*", # Typ obrazu z którym wtyczka może współpracować
          [
              (PF_IMAGE, "image", "Obraz wejściowy", None), # Wskazanie obrazu
              (PF_DRAWABLE, "drawable", "Oryginalna warstwa", None), # Wskazanie warstwy
              (PF_INT, "border_width", "Szerokość ramki", "10"), # szerokość ramki
              (PF_COLOR, "border_color",  "Kolor ramki", (251, 3, 20)) # Kolor ramki, określamy go 
			  #w postaci listy 3 wartości RGB, zastosowano kolor czerwony, wartości odczytano z 
			  # okna "Zmiana aktywnego koloru".
              
          ], # Pomiędzy tymi nawiasami klamrowymi zawarte są parametry wyświetlane w interaktywnym oknie wtyczki
          [], # Spis zmiennych, które zwróci wtyczka rezultat
          add_colored_border, menu="<Image>/TEST") # Nazwa procedury (funkcji) def i ścieżka do punktu menu, 
		  #w którym umieszczone będzie uruchamianie wtyczki

main() # Funkja uruchamiająca wtyczkę
